Imports ComponentPro

Namespace AdvancedDemo.Samples.Function_and_Property
	Friend Class Author
		Public ReadOnly Property Name() As String
			Get
				Return "John Borders"
			End Get
		End Property
	End Class

	Friend Class Book
		Public Shared ReadOnly Property StaticId() As String
			Get
				Return "AABB"
			End Get
		End Property
		Public ReadOnly Property BookId() As Integer
			Get
				Return 100
			End Get
		End Property
		Public ReadOnly Property Author() As Author
			Get
				Return New Author()
			End Get
		End Property
	End Class

	Friend Class Object_Property
		Inherits TemplateExampleBase
		''' <summary>
		''' Generates output from a template file.
		''' </summary>
		''' <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
		''' <param name="templateFile">The template file path.</param>
		''' <param name="templateSource">The template source loaded from the template file.</param>
		''' <returns>The generated output.</returns>
		Public Overrides Function Generate(ByVal templateSourceDirectory As String, ByVal templateFile As String, ByVal templateSource As String) As String
			' Create a new instance of the TemplateEngine class.
			Dim dt As New TemplateEngine()

			' Load template content from a file.
			dt.LoadFromString(templateSource)
			dt.SetValue("TemplateSourceDirectory", templateSourceDirectory)

			Dim mybook As New Book()
			dt.SetValue("bk", mybook)

			dt.UsingNamespace("AdvancedDemo.Samples.Function_and_Property,AdvancedDemo")

			' Generate output.
			Dim output As String = dt.Run()

			Return output
		End Function
	End Class
End Namespace
